/* 
 * chmoderr.c 
 *
 * Присвоєю заданому файлу задані права доступу.
 * Ілюструє порядок обробки помилок системних викликів.
 *
 */

#include <assert.h>
#include <errno.h>
#include <libgen.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>


int main(int argc, char *argv[])
{
        int rval;
    
        if (argc != 3) {
                fprintf(stderr, "Usage: %s path mode\n",
                                        basename(argv[0]));
                exit(EXIT_FAILURE);
        }

        rval = chmod(argv[1], (mode_t) strtol(argv[2], NULL, 8));
        if (rval != 0) {
                int error_code = errno;

                assert(rval == -1);
                switch (error_code) {
                case EPERM:
                case EROFS:
                case ENAMETOOLONG:
                case ENOENT:
                case ENOTDIR:
                case EACCES:
                case ELOOP:
                        fprintf(stderr, "Error changing mode of %s to"
                                        " %s: %s\n", argv[1], argv[2], 
                                                strerror(error_code));
                        break;
                case EFAULT:
                        abort();
                case ENOMEM:
                        perror("chmod()");
                        exit(EXIT_FAILURE);
                default:
                        abort();	
                }
        }
        exit(EXIT_SUCCESS);
}
